@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Azure ML Service linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authentication Type of authentication (Required to specify MSI) used to connect to AzureML. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property mlWorkspaceName Azure ML Service workspace name. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property resourceGroupName Azure ML Service workspace resource group name. Type: string (or Expression with resultType string).
 * @property servicePrincipalId The ID of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The key of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline.
 * @property subscriptionId Azure ML Service workspace subscription ID. Type: string (or Expression with resultType string).
 * @property tenant The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureMLService'.
 */
public data class AzureMLServiceLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val authentication: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val mlWorkspaceName: Any,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val resourceGroupName: Any,
    public val servicePrincipalId: Any? = null,
    public val servicePrincipalKey: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val subscriptionId: Any,
    public val tenant: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureMLServiceLinkedServiceResponse): AzureMLServiceLinkedServiceResponse = AzureMLServiceLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authentication = javaType.authentication().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            mlWorkspaceName = javaType.mlWorkspaceName(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            resourceGroupName = javaType.resourceGroupName(),
            servicePrincipalId = javaType.servicePrincipalId().map({ args0 -> args0 }).orElse(null),
            servicePrincipalKey = javaType.servicePrincipalKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            subscriptionId = javaType.subscriptionId(),
            tenant = javaType.tenant().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
