@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Azure ML WebService Input/Output file
 * @property filePath The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string).
 * @property linkedServiceName Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
 */
public data class AzureMLWebServiceFileResponse(
    public val filePath: Any,
    public val linkedServiceName: LinkedServiceReferenceResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureMLWebServiceFileResponse): AzureMLWebServiceFileResponse = AzureMLWebServiceFileResponse(
            filePath = javaType.filePath(),
            linkedServiceName = javaType.linkedServiceName().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
