@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Binary read settings.
 * @property compressionProperties Compression settings.
 * @property type The read setting type.
 * Expected value is 'BinaryReadSettings'.
 */
public data class BinaryReadSettingsResponse(
    public val compressionProperties: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.BinaryReadSettingsResponse): BinaryReadSettingsResponse = BinaryReadSettingsResponse(
            compressionProperties = javaType.compressionProperties().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
