@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Trigger that runs every time a Blob event occurs.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property blobPathBeginsWith The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
 * @property blobPathEndsWith The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
 * @property description Trigger description.
 * @property events The type of events that cause this trigger to fire.
 * @property ignoreEmptyBlobs If set to true, blobs with zero bytes will be ignored.
 * @property pipelines Pipelines that need to be started.
 * @property runtimeState Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
 * @property scope The ARM resource ID of the Storage Account.
 * @property type Trigger type.
 * Expected value is 'BlobEventsTrigger'.
 */
public data class BlobEventsTriggerResponse(
    public val annotations: List<Any>? = null,
    public val blobPathBeginsWith: String? = null,
    public val blobPathEndsWith: String? = null,
    public val description: String? = null,
    public val events: List<String>,
    public val ignoreEmptyBlobs: Boolean? = null,
    public val pipelines: List<TriggerPipelineReferenceResponse>? = null,
    public val runtimeState: String,
    public val scope: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.BlobEventsTriggerResponse): BlobEventsTriggerResponse = BlobEventsTriggerResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            blobPathBeginsWith = javaType.blobPathBeginsWith().map({ args0 -> args0 }).orElse(null),
            blobPathEndsWith = javaType.blobPathEndsWith().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            events = javaType.events().map({ args0 -> args0 }),
            ignoreEmptyBlobs = javaType.ignoreEmptyBlobs().map({ args0 -> args0 }).orElse(null),
            pipelines = javaType.pipelines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.TriggerPipelineReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            runtimeState = javaType.runtimeState(),
            scope = javaType.scope(),
            type = javaType.type(),
        )
    }
}
