@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A copy activity Azure Blob sink.
 * @property blobWriterAddHeader Blob writer add header. Type: boolean (or Expression with resultType boolean).
 * @property blobWriterDateTimeFormat Blob writer date time format. Type: string (or Expression with resultType string).
 * @property blobWriterOverwriteFiles Blob writer overwrite files. Type: boolean (or Expression with resultType boolean).
 * @property copyBehavior The type of copy behavior for copy sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property metadata Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy sink type.
 * Expected value is 'BlobSink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 */
public data class BlobSinkResponse(
    public val blobWriterAddHeader: Any? = null,
    public val blobWriterDateTimeFormat: Any? = null,
    public val blobWriterOverwriteFiles: Any? = null,
    public val copyBehavior: Any? = null,
    public val disableMetricsCollection: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val metadata: List<MetadataItemResponse>? = null,
    public val sinkRetryCount: Any? = null,
    public val sinkRetryWait: Any? = null,
    public val type: String,
    public val writeBatchSize: Any? = null,
    public val writeBatchTimeout: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.BlobSinkResponse): BlobSinkResponse = BlobSinkResponse(
            blobWriterAddHeader = javaType.blobWriterAddHeader().map({ args0 -> args0 }).orElse(null),
            blobWriterDateTimeFormat = javaType.blobWriterDateTimeFormat().map({ args0 -> args0 }).orElse(null),
            blobWriterOverwriteFiles = javaType.blobWriterOverwriteFiles().map({ args0 -> args0 }).orElse(null),
            copyBehavior = javaType.copyBehavior().map({ args0 -> args0 }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MetadataItemResponse.Companion.toKotlin(args0)
                })
            }),
            sinkRetryCount = javaType.sinkRetryCount().map({ args0 -> args0 }).orElse(null),
            sinkRetryWait = javaType.sinkRetryWait().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            writeBatchSize = javaType.writeBatchSize().map({ args0 -> args0 }).orElse(null),
            writeBatchTimeout = javaType.writeBatchTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
