@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Common Data Service for Apps linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The authentication type to connect to Common Data Service for Apps server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario. 'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property deploymentType The deployment type of the Common Data Service for Apps instance. 'Online' for Common Data Service for Apps Online and 'OnPremisesWithIfd' for Common Data Service for Apps on-premises with Ifd. Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property hostName The host name of the on-premises Common Data Service for Apps server. The property is required for on-prem and not allowed for online. Type: string (or Expression with resultType string).
 * @property organizationName The organization name of the Common Data Service for Apps instance. The property is required for on-prem and required for online when there are more than one Common Data Service for Apps instances associated with the user. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property password Password to access the Common Data Service for Apps instance.
 * @property port The port of on-premises Common Data Service for Apps server. The property is required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property servicePrincipalCredential The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
 * @property servicePrincipalCredentialType The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string).
 * @property servicePrincipalId The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression with resultType string).
 * @property serviceUri The URL to the Microsoft Common Data Service for Apps server. The property is required for on-line and not allowed for on-prem. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'CommonDataServiceForApps'.
 * @property username User name to access the Common Data Service for Apps instance. Type: string (or Expression with resultType string).
 */
public data class CommonDataServiceForAppsLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val authenticationType: Any,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val deploymentType: Any,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val hostName: Any? = null,
    public val organizationName: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val port: Any? = null,
    public val servicePrincipalCredential: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val servicePrincipalCredentialType: Any? = null,
    public val servicePrincipalId: Any? = null,
    public val serviceUri: Any? = null,
    public val type: String,
    public val username: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.CommonDataServiceForAppsLinkedServiceResponse): CommonDataServiceForAppsLinkedServiceResponse =
            CommonDataServiceForAppsLinkedServiceResponse(
                annotations = javaType.annotations().map({ args0 -> args0 }),
                authenticationType = javaType.authenticationType(),
                connectVia = javaType.connectVia().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                deploymentType = javaType.deploymentType(),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
                hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
                organizationName = javaType.organizationName().map({ args0 -> args0 }).orElse(null),
                parameters = javaType.parameters().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
                password = javaType.password().map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                }).orElse(null),
                port = javaType.port().map({ args0 -> args0 }).orElse(null),
                servicePrincipalCredential = javaType.servicePrincipalCredential().map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                }).orElse(null),
                servicePrincipalCredentialType = javaType.servicePrincipalCredentialType().map({ args0 ->
                    args0
                }).orElse(null),
                servicePrincipalId = javaType.servicePrincipalId().map({ args0 -> args0 }).orElse(null),
                serviceUri = javaType.serviceUri().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
                username = javaType.username().map({ args0 -> args0 }).orElse(null),
            )
    }
}
