@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * CopyComputeScale properties for managed integration runtime.
 * @property dataIntegrationUnit DIU number setting reserved for copy activity execution. Supported values are multiples of 4 in range 4-256.
 * @property timeToLive Time to live (in minutes) setting of integration runtime which will execute copy activity.
 */
public data class CopyComputeScalePropertiesResponse(
    public val dataIntegrationUnit: Int? = null,
    public val timeToLive: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.CopyComputeScalePropertiesResponse): CopyComputeScalePropertiesResponse = CopyComputeScalePropertiesResponse(
            dataIntegrationUnit = javaType.dataIntegrationUnit().map({ args0 -> args0 }).orElse(null),
            timeToLive = javaType.timeToLive().map({ args0 -> args0 }).orElse(null),
        )
    }
}
