@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity Azure CosmosDB (SQL API) Collection sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy sink type.
 * Expected value is 'CosmosDbSqlApiSink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property writeBehavior Describes how to write data to Azure Cosmos DB. Type: string (or Expression with resultType string). Allowed values: insert and upsert.
 */
public data class CosmosDbSqlApiSinkResponse(
    public val disableMetricsCollection: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val sinkRetryCount: Any? = null,
    public val sinkRetryWait: Any? = null,
    public val type: String,
    public val writeBatchSize: Any? = null,
    public val writeBatchTimeout: Any? = null,
    public val writeBehavior: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.CosmosDbSqlApiSinkResponse): CosmosDbSqlApiSinkResponse = CosmosDbSqlApiSinkResponse(
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            sinkRetryCount = javaType.sinkRetryCount().map({ args0 -> args0 }).orElse(null),
            sinkRetryWait = javaType.sinkRetryWait().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            writeBatchSize = javaType.writeBatchSize().map({ args0 -> args0 }).orElse(null),
            writeBatchTimeout = javaType.writeBatchTimeout().map({ args0 -> args0 }).orElse(null),
            writeBehavior = javaType.writeBehavior().map({ args0 -> args0 }).orElse(null),
        )
    }
}
