@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Credential reference type.
 * @property referenceName Reference credential name.
 * @property type Credential reference type.
 */
public data class CredentialReferenceResponse(
    public val referenceName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.CredentialReferenceResponse): CredentialReferenceResponse = CredentialReferenceResponse(
            referenceName = javaType.referenceName(),
            type = javaType.type(),
        )
    }
}
