@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Default value.
 * @property columnName Column name. Type: object (or Expression with resultType string).
 * @property defaultValue The default value of the column. Type: object (or Expression with resultType string).
 */
public data class DWCopyCommandDefaultValueResponse(
    public val columnName: Any? = null,
    public val defaultValue: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.DWCopyCommandDefaultValueResponse): DWCopyCommandDefaultValueResponse = DWCopyCommandDefaultValueResponse(
            columnName = javaType.columnName().map({ args0 -> args0 }).orElse(null),
            defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
