@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Transformation for data flow source.
 * @property dataset Dataset reference.
 * @property description Transformation description.
 * @property flowlet Flowlet Reference
 * @property linkedService Linked service reference.
 * @property name Transformation name.
 * @property schemaLinkedService Schema linked service reference.
 */
public data class DataFlowSourceResponse(
    public val dataset: DatasetReferenceResponse? = null,
    public val description: String? = null,
    public val flowlet: DataFlowReferenceResponse? = null,
    public val linkedService: LinkedServiceReferenceResponse? = null,
    public val name: String,
    public val schemaLinkedService: LinkedServiceReferenceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.DataFlowSourceResponse): DataFlowSourceResponse = DataFlowSourceResponse(
            dataset = javaType.dataset().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            flowlet = javaType.flowlet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DataFlowReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            linkedService = javaType.linkedService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            schemaLinkedService = javaType.schemaLinkedService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
