@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Data Lake Analytics U-SQL activity.
 * @property compilationMode Compilation mode of U-SQL. Must be one of these values : Semantic, Full and SingleBox. Type: string (or Expression with resultType string).
 * @property degreeOfParallelism The maximum number of nodes simultaneously used to run the job. Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property parameters Parameters for U-SQL job request.
 * @property policy Activity policy.
 * @property priority Determines which jobs out of all that are queued should be selected to run first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or Expression with resultType integer), minimum: 1.
 * @property runtimeVersion Runtime version of the U-SQL engine to use. Type: string (or Expression with resultType string).
 * @property scriptLinkedService Script linked service reference.
 * @property scriptPath Case-sensitive path to folder that contains the U-SQL script. Type: string (or Expression with resultType string).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'DataLakeAnalyticsU-SQL'.
 * @property userProperties Activity user properties.
 */
public data class DataLakeAnalyticsUSQLActivityResponse(
    public val compilationMode: Any? = null,
    public val degreeOfParallelism: Any? = null,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val parameters: Map<String, Any>? = null,
    public val policy: ActivityPolicyResponse? = null,
    public val priority: Any? = null,
    public val runtimeVersion: Any? = null,
    public val scriptLinkedService: LinkedServiceReferenceResponse,
    public val scriptPath: Any,
    public val state: String? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.DataLakeAnalyticsUSQLActivityResponse): DataLakeAnalyticsUSQLActivityResponse = DataLakeAnalyticsUSQLActivityResponse(
            compilationMode = javaType.compilationMode().map({ args0 -> args0 }).orElse(null),
            degreeOfParallelism = javaType.degreeOfParallelism().map({ args0 -> args0 }).orElse(null),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            runtimeVersion = javaType.runtimeVersion().map({ args0 -> args0 }).orElse(null),
            scriptLinkedService = javaType.scriptLinkedService().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            scriptPath = javaType.scriptPath(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
