@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Source and target table mapping details.
 * @property attributeMappingInfo This holds the user provided attribute mapping information.
 * @property sourceConnectionReference The connection reference for the source connection.
 * @property sourceDenormalizeInfo This holds the source denormalization information used while joining multiple sources.
 * @property sourceEntityName Name of the source table
 * @property targetEntityName Name of the target table
 */
public data class DataMapperMappingResponse(
    public val attributeMappingInfo: MapperAttributeMappingsResponse? = null,
    public val sourceConnectionReference: MapperConnectionReferenceResponse? = null,
    public val sourceDenormalizeInfo: Any? = null,
    public val sourceEntityName: String? = null,
    public val targetEntityName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.DataMapperMappingResponse): DataMapperMappingResponse = DataMapperMappingResponse(
            attributeMappingInfo = javaType.attributeMappingInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperAttributeMappingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceConnectionReference = javaType.sourceConnectionReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperConnectionReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceDenormalizeInfo = javaType.sourceDenormalizeInfo().map({ args0 -> args0 }).orElse(null),
            sourceEntityName = javaType.sourceEntityName().map({ args0 -> args0 }).orElse(null),
            targetEntityName = javaType.targetEntityName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
