@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * DatabricksSparkPython activity.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property libraries A list of libraries to be installed on the cluster that will execute the job.
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property parameters Command line parameters that will be passed to the Python file.
 * @property policy Activity policy.
 * @property pythonFile The URI of the Python file to be executed. DBFS paths are supported. Type: string (or Expression with resultType string).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'DatabricksSparkPython'.
 * @property userProperties Activity user properties.
 */
public data class DatabricksSparkPythonActivityResponse(
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val libraries: List<Map<String, Any>>? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val parameters: List<Any>? = null,
    public val policy: ActivityPolicyResponse? = null,
    public val pythonFile: Any,
    public val state: String? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.DatabricksSparkPythonActivityResponse): DatabricksSparkPythonActivityResponse = DatabricksSparkPythonActivityResponse(
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            libraries = javaType.libraries().map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
            linkedServiceName = javaType.linkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0 }),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            pythonFile = javaType.pythonFile(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
