@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * The compression method used on a dataset.
 * @property level The dataset compression level. Type: string (or Expression with resultType string).
 * @property type Type of dataset compression. Type: string (or Expression with resultType string).
 */
public data class DatasetCompressionResponse(
    public val level: Any? = null,
    public val type: Any,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.DatasetCompressionResponse): DatasetCompressionResponse = DatasetCompressionResponse(
            level = javaType.level().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
