@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Delimited text dataset.
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property columnDelimiter The column delimiter. Type: string (or Expression with resultType string).
 * @property compressionCodec The data compressionCodec. Type: string (or Expression with resultType string).
 * @property compressionLevel The data compression method used for DelimitedText.
 * @property description Dataset description.
 * @property encodingName The code page name of the preferred encoding. If miss, the default value is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column of the table in the following link to set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType string).
 * @property escapeChar The escape character. Type: string (or Expression with resultType string).
 * @property firstRowAsHeader When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property linkedServiceName Linked service reference.
 * @property location The location of the delimited text storage.
 * @property nullValue The null value string. Type: string (or Expression with resultType string).
 * @property parameters Parameters for dataset.
 * @property quoteChar The quote character. Type: string (or Expression with resultType string).
 * @property rowDelimiter The row delimiter. Type: string (or Expression with resultType string).
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property type Type of dataset.
 * Expected value is 'DelimitedText'.
 */
public data class DelimitedTextDatasetResponse(
    public val annotations: List<Any>? = null,
    public val columnDelimiter: Any? = null,
    public val compressionCodec: Any? = null,
    public val compressionLevel: Any? = null,
    public val description: String? = null,
    public val encodingName: Any? = null,
    public val escapeChar: Any? = null,
    public val firstRowAsHeader: Any? = null,
    public val folder: DatasetResponseFolder? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse,
    public val location: Any,
    public val nullValue: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val quoteChar: Any? = null,
    public val rowDelimiter: Any? = null,
    public val schema: Any? = null,
    public val structure: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.DelimitedTextDatasetResponse): DelimitedTextDatasetResponse = DelimitedTextDatasetResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            columnDelimiter = javaType.columnDelimiter().map({ args0 -> args0 }).orElse(null),
            compressionCodec = javaType.compressionCodec().map({ args0 -> args0 }).orElse(null),
            compressionLevel = javaType.compressionLevel().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encodingName = javaType.encodingName().map({ args0 -> args0 }).orElse(null),
            escapeChar = javaType.escapeChar().map({ args0 -> args0 }).orElse(null),
            firstRowAsHeader = javaType.firstRowAsHeader().map({ args0 -> args0 }).orElse(null),
            folder = javaType.folder().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetResponseFolder.Companion.toKotlin(args0)
                })
            }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            nullValue = javaType.nullValue().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            quoteChar = javaType.quoteChar().map({ args0 -> args0 }).orElse(null),
            rowDelimiter = javaType.rowDelimiter().map({ args0 -> args0 }).orElse(null),
            schema = javaType.schema().map({ args0 -> args0 }).orElse(null),
            structure = javaType.structure().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
