@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Distcp settings.
 * @property distcpOptions Specifies the Distcp options. Type: string (or Expression with resultType string).
 * @property resourceManagerEndpoint Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string).
 * @property tempScriptPath Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string).
 */
public data class DistcpSettingsResponse(
    public val distcpOptions: Any? = null,
    public val resourceManagerEndpoint: Any,
    public val tempScriptPath: Any,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.DistcpSettingsResponse): DistcpSettingsResponse = DistcpSettingsResponse(
            distcpOptions = javaType.distcpOptions().map({ args0 -> args0 }).orElse(null),
            resourceManagerEndpoint = javaType.resourceManagerEndpoint(),
            tempScriptPath = javaType.tempScriptPath(),
        )
    }
}
