@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The entity reference.
 * @property referenceName The name of this referenced entity.
 * @property type The type of this referenced entity.
 */
public data class EntityReferenceResponse(
    public val referenceName: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.EntityReferenceResponse): EntityReferenceResponse = EntityReferenceResponse(
            referenceName = javaType.referenceName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
