@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The custom setup of setting environment variable.
 * @property type The type of custom setup.
 * Expected value is 'EnvironmentVariableSetup'.
 * @property variableName The name of the environment variable.
 * @property variableValue The value of the environment variable.
 */
public data class EnvironmentVariableSetupResponse(
    public val type: String,
    public val variableName: String,
    public val variableValue: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.EnvironmentVariableSetupResponse): EnvironmentVariableSetupResponse = EnvironmentVariableSetupResponse(
            type = javaType.type(),
            variableName = javaType.variableName(),
            variableValue = javaType.variableValue(),
        )
    }
}
