@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Execute pipeline activity.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property parameters Pipeline parameters.
 * @property pipeline Pipeline reference.
 * @property policy Execute pipeline activity policy.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'ExecutePipeline'.
 * @property userProperties Activity user properties.
 * @property waitOnCompletion Defines whether activity execution will wait for the dependent pipeline execution to finish. Default is false.
 */
public data class ExecutePipelineActivityResponse(
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val parameters: Map<String, Any>? = null,
    public val pipeline: PipelineReferenceResponse,
    public val policy: ExecutePipelineActivityPolicyResponse? = null,
    public val state: String? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
    public val waitOnCompletion: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ExecutePipelineActivityResponse): ExecutePipelineActivityResponse = ExecutePipelineActivityResponse(
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            pipeline = javaType.pipeline().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.PipelineReferenceResponse.Companion.toKotlin(args0)
            }),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ExecutePipelineActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
            waitOnCompletion = javaType.waitOnCompletion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
