@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Execute SSIS package activity.
 * @property connectVia The integration runtime reference.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property environmentPath The environment path to execute the SSIS package. Type: string (or Expression with resultType string).
 * @property executionCredential The package execution credential.
 * @property linkedServiceName Linked service reference.
 * @property logLocation SSIS package execution log location.
 * @property loggingLevel The logging level of SSIS package execution. Type: string (or Expression with resultType string).
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property packageConnectionManagers The package level connection managers to execute the SSIS package.
 * @property packageLocation SSIS package location.
 * @property packageParameters The package level parameters to execute the SSIS package.
 * @property policy Activity policy.
 * @property projectConnectionManagers The project level connection managers to execute the SSIS package.
 * @property projectParameters The project level parameters to execute the SSIS package.
 * @property propertyOverrides The property overrides to execute the SSIS package.
 * @property runtime Specifies the runtime to execute SSIS package. The value should be "x86" or "x64". Type: string (or Expression with resultType string).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'ExecuteSSISPackage'.
 * @property userProperties Activity user properties.
 */
public data class ExecuteSSISPackageActivityResponse(
    public val connectVia: IntegrationRuntimeReferenceResponse,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val environmentPath: Any? = null,
    public val executionCredential: SSISExecutionCredentialResponse? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse? = null,
    public val logLocation: SSISLogLocationResponse? = null,
    public val loggingLevel: Any? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val packageConnectionManagers: Map<String, Map<String, SSISExecutionParameterResponse>>? =
        null,
    public val packageLocation: SSISPackageLocationResponse,
    public val packageParameters: Map<String, SSISExecutionParameterResponse>? = null,
    public val policy: ActivityPolicyResponse? = null,
    public val projectConnectionManagers: Map<String, Map<String, SSISExecutionParameterResponse>>? =
        null,
    public val projectParameters: Map<String, SSISExecutionParameterResponse>? = null,
    public val propertyOverrides: Map<String, SSISPropertyOverrideResponse>? = null,
    public val runtime: Any? = null,
    public val state: String? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ExecuteSSISPackageActivityResponse): ExecuteSSISPackageActivityResponse = ExecuteSSISPackageActivityResponse(
            connectVia = javaType.connectVia().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
            }),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            environmentPath = javaType.environmentPath().map({ args0 -> args0 }).orElse(null),
            executionCredential = javaType.executionCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SSISExecutionCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            logLocation = javaType.logLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SSISLogLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            loggingLevel = javaType.loggingLevel().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            packageConnectionManagers = javaType.packageConnectionManagers().map({ args0 ->
                args0.key.to(
                    args0.value.map({ args0 ->
                        args0.key.to(
                            args0.value.let({ args0 ->
                                com.pulumi.azurenative.datafactory.kotlin.outputs.SSISExecutionParameterResponse.Companion.toKotlin(args0)
                            }),
                        )
                    }).toMap(),
                )
            }).toMap(),
            packageLocation = javaType.packageLocation().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.SSISPackageLocationResponse.Companion.toKotlin(args0)
            }),
            packageParameters = javaType.packageParameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.SSISExecutionParameterResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            projectConnectionManagers = javaType.projectConnectionManagers().map({ args0 ->
                args0.key.to(
                    args0.value.map({ args0 ->
                        args0.key.to(
                            args0.value.let({ args0 ->
                                com.pulumi.azurenative.datafactory.kotlin.outputs.SSISExecutionParameterResponse.Companion.toKotlin(args0)
                            }),
                        )
                    }).toMap(),
                )
            }).toMap(),
            projectParameters = javaType.projectParameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.SSISExecutionParameterResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            propertyOverrides = javaType.propertyOverrides().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.SSISPropertyOverrideResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            runtime = javaType.runtime().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
