@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * This activity is used for iterating over a collection and execute given activities.
 * @property activities List of activities to execute .
 * @property batchCount Batch count to be used for controlling the number of parallel execution (when isSequential is set to false).
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property isSequential Should the loop be executed in sequence or in parallel (max 50)
 * @property items Collection to iterate.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'ForEach'.
 * @property userProperties Activity user properties.
 */
public data class ForEachActivityResponse(
    public val activities: List<Any>,
    public val batchCount: Int? = null,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val isSequential: Boolean? = null,
    public val items: ExpressionResponse,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val state: String? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ForEachActivityResponse): ForEachActivityResponse = ForEachActivityResponse(
            activities = javaType.activities().map({ args0 -> args0 }),
            batchCount = javaType.batchCount().map({ args0 -> args0 }).orElse(null),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            isSequential = javaType.isSequential().map({ args0 -> args0 }).orElse(null),
            items = javaType.items().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.ExpressionResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
