@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A FTP server Linked Service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The authentication type to be used to connect to the FTP server.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property enableServerCertificateValidation If true, validate the FTP server SSL certificate when connect over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
 * @property enableSsl If true, connect to the FTP server over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType boolean).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property host Host name of the FTP server. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property password Password to logon the FTP server.
 * @property port The TCP port number that the FTP server uses to listen for client connections. Default value is 21. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property type Type of linked service.
 * Expected value is 'FtpServer'.
 * @property userName Username to logon the FTP server. Type: string (or Expression with resultType string).
 */
public data class FtpServerLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val authenticationType: String? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val enableServerCertificateValidation: Any? = null,
    public val enableSsl: Any? = null,
    public val encryptedCredential: String? = null,
    public val host: Any,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val port: Any? = null,
    public val type: String,
    public val userName: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.FtpServerLinkedServiceResponse): FtpServerLinkedServiceResponse = FtpServerLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            enableServerCertificateValidation = javaType.enableServerCertificateValidation().map({ args0 ->
                args0
            }).orElse(null),
            enableSsl = javaType.enableSsl().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            host = javaType.host(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
