@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Change data capture resource type.
 * @property allowVNetOverride A boolean to determine if the vnet configuration needs to be overwritten.
 * @property description The description of the change data capture.
 * @property etag Etag identifies change in the resource.
 * @property folder The folder that this CDC is in. If not specified, CDC will appear at the root level.
 * @property id The resource identifier.
 * @property name The resource name.
 * @property policy CDC policy
 * @property sourceConnectionsInfo List of sources connections that can be used as sources in the CDC.
 * @property status Status of the CDC as to if it is running or stopped.
 * @property targetConnectionsInfo List of target connections that can be used as sources in the CDC.
 * @property type The resource type.
 */
public data class GetChangeDataCaptureResult(
    public val allowVNetOverride: Boolean? = null,
    public val description: String? = null,
    public val etag: String,
    public val folder: ChangeDataCaptureResponseFolder? = null,
    public val id: String,
    public val name: String,
    public val policy: MapperPolicyResponse,
    public val sourceConnectionsInfo: List<MapperSourceConnectionsInfoResponse>,
    public val status: String? = null,
    public val targetConnectionsInfo: List<MapperTargetConnectionsInfoResponse>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GetChangeDataCaptureResult): GetChangeDataCaptureResult = GetChangeDataCaptureResult(
            allowVNetOverride = javaType.allowVNetOverride().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            folder = javaType.folder().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ChangeDataCaptureResponseFolder.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            policy = javaType.policy().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.MapperPolicyResponse.Companion.toKotlin(args0)
            }),
            sourceConnectionsInfo = javaType.sourceConnectionsInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperSourceConnectionsInfoResponse.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            targetConnectionsInfo = javaType.targetConnectionsInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperTargetConnectionsInfoResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
