@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Get Data Plane read only token response definition.
 * @property accessToken Data Plane read only access token.
 * @property dataPlaneUrl Data Plane service base URL.
 * @property policy The user access policy.
 */
public data class GetFactoryDataPlaneAccessResult(
    public val accessToken: String? = null,
    public val dataPlaneUrl: String? = null,
    public val policy: UserAccessPolicyResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GetFactoryDataPlaneAccessResult): GetFactoryDataPlaneAccessResult = GetFactoryDataPlaneAccessResult(
            accessToken = javaType.accessToken().map({ args0 -> args0 }).orElse(null),
            dataPlaneUrl = javaType.dataPlaneUrl().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserAccessPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
