@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Factory resource type.
 * @property createTime Time the factory was created in ISO8601 format.
 * @property eTag Etag identifies change in the resource.
 * @property encryption Properties to enable Customer Managed Key for the factory.
 * @property globalParameters List of parameters for factory.
 * @property id The resource identifier.
 * @property identity Managed service identity of the factory.
 * @property location The resource location.
 * @property name The resource name.
 * @property provisioningState Factory provisioning state, example Succeeded.
 * @property publicNetworkAccess Whether or not public network access is allowed for the data factory.
 * @property purviewConfiguration Purview information of the factory.
 * @property repoConfiguration Git repo information of the factory.
 * @property tags The resource tags.
 * @property type The resource type.
 * @property version Version of the factory.
 */
public data class GetFactoryResult(
    public val createTime: String,
    public val eTag: String,
    public val encryption: EncryptionConfigurationResponse? = null,
    public val globalParameters: Map<String, GlobalParameterSpecificationResponse>? = null,
    public val id: String,
    public val identity: FactoryIdentityResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val purviewConfiguration: PurviewConfigurationResponse? = null,
    public val repoConfiguration: Either<FactoryGitHubConfigurationResponse, FactoryVSTSConfigurationResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GetFactoryResult): GetFactoryResult = GetFactoryResult(
            createTime = javaType.createTime(),
            eTag = javaType.eTag(),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.EncryptionConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            globalParameters = javaType.globalParameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.GlobalParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.FactoryIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            purviewConfiguration = javaType.purviewConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.PurviewConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            repoConfiguration = javaType.repoConfiguration().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.FactoryGitHubConfigurationResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.FactoryVSTSConfigurationResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
