@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Global parameters resource type.
 * @property etag Etag identifies change in the resource.
 * @property id The resource identifier.
 * @property name The resource name.
 * @property properties Properties of the global parameter.
 * @property type The resource type.
 */
public data class GetGlobalParameterResult(
    public val etag: String,
    public val id: String,
    public val name: String,
    public val properties: Map<String, GlobalParameterSpecificationResponse>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GetGlobalParameterResult): GetGlobalParameterResult = GetGlobalParameterResult(
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.GlobalParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            type = javaType.type(),
        )
    }
}
