@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Connection information for encrypting the on-premises data source credentials.
 * @property hostServiceUri The on-premises integration runtime host URL.
 * @property identityCertThumbprint The integration runtime SSL certificate thumbprint. Click-Once application uses it to do server validation.
 * @property isIdentityCertExprired Whether the identity certificate is expired.
 * @property publicKey The public key for encrypting a credential when transferring the credential to the integration runtime.
 * @property serviceToken The token generated in service. Callers use this token to authenticate to integration runtime.
 * @property version The integration runtime version.
 */
public data class GetIntegrationRuntimeConnectionInfoResult(
    public val hostServiceUri: String,
    public val identityCertThumbprint: String,
    public val isIdentityCertExprired: Boolean,
    public val publicKey: String,
    public val serviceToken: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GetIntegrationRuntimeConnectionInfoResult): GetIntegrationRuntimeConnectionInfoResult = GetIntegrationRuntimeConnectionInfoResult(
            hostServiceUri = javaType.hostServiceUri(),
            identityCertThumbprint = javaType.identityCertThumbprint(),
            isIdentityCertExprired = javaType.isIdentityCertExprired(),
            publicKey = javaType.publicKey(),
            serviceToken = javaType.serviceToken(),
            version = javaType.version(),
        )
    }
}
