@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A list of SSIS object metadata.
 * @property nextLink The link to the next page of results, if any remaining results exist.
 * @property value List of SSIS object metadata.
 */
public data class GetIntegrationRuntimeObjectMetadatumResult(
    public val nextLink: String? = null,
    public val `value`: List<Any>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GetIntegrationRuntimeObjectMetadatumResult): GetIntegrationRuntimeObjectMetadatumResult = GetIntegrationRuntimeObjectMetadatumResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }),
        )
    }
}
