@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Integration runtime resource type.
 * @property etag Etag identifies change in the resource.
 * @property id The resource identifier.
 * @property name The resource name.
 * @property properties Integration runtime properties.
 * @property type The resource type.
 */
public data class GetIntegrationRuntimeResult(
    public val etag: String,
    public val id: String,
    public val name: String,
    public val properties: Either<ManagedIntegrationRuntimeResponse, SelfHostedIntegrationRuntimeResponse>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GetIntegrationRuntimeResult): GetIntegrationRuntimeResult = GetIntegrationRuntimeResult(
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ManagedIntegrationRuntimeResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.SelfHostedIntegrationRuntimeResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            type = javaType.type(),
        )
    }
}
