@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Integration runtime status response.
 * @property name The integration runtime name.
 * @property properties Integration runtime properties.
 */
public data class GetIntegrationRuntimeStatusResult(
    public val name: String,
    public val properties: Either<ManagedIntegrationRuntimeStatusResponse, SelfHostedIntegrationRuntimeStatusResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GetIntegrationRuntimeStatusResult): GetIntegrationRuntimeStatusResult = GetIntegrationRuntimeStatusResult(
            name = javaType.name(),
            properties = javaType.properties().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ManagedIntegrationRuntimeStatusResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.SelfHostedIntegrationRuntimeStatusResponse.Companion.toKotlin(args0)
                    })
                },
            ),
        )
    }
}
