@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Private Endpoint Connection ARM resource.
 * @property etag Etag identifies change in the resource.
 * @property id The resource identifier.
 * @property name The resource name.
 * @property properties Core resource properties
 * @property type The resource type.
 */
public data class GetPrivateEndpointConnectionResult(
    public val etag: String,
    public val id: String,
    public val name: String,
    public val properties: RemotePrivateEndpointConnectionResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GetPrivateEndpointConnectionResult): GetPrivateEndpointConnectionResult = GetPrivateEndpointConnectionResult(
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.RemotePrivateEndpointConnectionResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
