@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Google AdWords service linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
 * @property clientCustomerID The Client customer ID of the AdWords account that you want to fetch report data for. Type: string (or Expression with resultType string).
 * @property clientId The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string).
 * @property clientSecret The client secret of the google application used to acquire the refresh token.
 * @property connectVia The integration runtime reference.
 * @property connectionProperties (Deprecated) Properties used to connect to GoogleAds. It is mutually exclusive with any other properties in the linked service. Type: object.
 * @property description Linked service description.
 * @property developerToken The developer token associated with the manager account that you use to grant access to the AdWords API.
 * @property email The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property googleAdsApiVersion The Google Ads API major version such as v14. The supported major versions could be found on https://developers.google.com/google-ads/api/docs/release-notes. Type: string (or Expression with resultType string).
 * @property keyFilePath (Deprecated) The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
 * @property loginCustomerID The customer ID of the Google Ads Manager account through which you want to fetch report data of specific Customer. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property privateKey The private key that is used to authenticate the service account email address and can only be used on self-hosted IR.
 * @property refreshToken The refresh token obtained from Google for authorizing access to AdWords for UserAuthentication.
 * @property supportLegacyDataTypes Specifies whether to use the legacy data type mappings, which maps float, int32 and int64 from Google to string. Do not set this to true unless you want to keep backward compatibility with legacy driver's data type mappings. Type: boolean (or Expression with resultType boolean).
 * @property trustedCertPath (Deprecated) The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'GoogleAdWords'.
 * @property useSystemTrustStore (Deprecated) Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false. Type: boolean (or Expression with resultType boolean).
 */
public data class GoogleAdWordsLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val authenticationType: String? = null,
    public val clientCustomerID: Any? = null,
    public val clientId: Any? = null,
    public val clientSecret: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val connectionProperties: Any? = null,
    public val description: String? = null,
    public val developerToken: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val email: Any? = null,
    public val encryptedCredential: String? = null,
    public val googleAdsApiVersion: Any? = null,
    public val keyFilePath: Any? = null,
    public val loginCustomerID: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val privateKey: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val refreshToken: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val supportLegacyDataTypes: Any? = null,
    public val trustedCertPath: Any? = null,
    public val type: String,
    public val useSystemTrustStore: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GoogleAdWordsLinkedServiceResponse): GoogleAdWordsLinkedServiceResponse = GoogleAdWordsLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            clientCustomerID = javaType.clientCustomerID().map({ args0 -> args0 }).orElse(null),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectionProperties = javaType.connectionProperties().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            developerToken = javaType.developerToken().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            googleAdsApiVersion = javaType.googleAdsApiVersion().map({ args0 -> args0 }).orElse(null),
            keyFilePath = javaType.keyFilePath().map({ args0 -> args0 }).orElse(null),
            loginCustomerID = javaType.loginCustomerID().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            privateKey = javaType.privateKey().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            refreshToken = javaType.refreshToken().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            supportLegacyDataTypes = javaType.supportLegacyDataTypes().map({ args0 -> args0 }).orElse(null),
            trustedCertPath = javaType.trustedCertPath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            useSystemTrustStore = javaType.useSystemTrustStore().map({ args0 -> args0 }).orElse(null),
        )
    }
}
