@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Google BigQuery service linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The OAuth 2.0 authentication mechanism used for authentication.
 * @property clientId The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string).
 * @property clientSecret The client secret of the google application used to acquire the refresh token.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property keyFileContent The content of the .json key file that is used to authenticate the service account. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property projectId The default BigQuery project id to query against. Type: string (or Expression with resultType string).
 * @property refreshToken The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
 * @property type Type of linked service.
 * Expected value is 'GoogleBigQueryV2'.
 */
public data class GoogleBigQueryV2LinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val authenticationType: String,
    public val clientId: Any? = null,
    public val clientSecret: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val keyFileContent: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val projectId: Any,
    public val refreshToken: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GoogleBigQueryV2LinkedServiceResponse): GoogleBigQueryV2LinkedServiceResponse = GoogleBigQueryV2LinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authenticationType = javaType.authenticationType(),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            keyFileContent = javaType.keyFileContent().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            projectId = javaType.projectId(),
            refreshToken = javaType.refreshToken().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
