@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * HDInsight Hive activity type.
 * @property arguments User specified arguments to HDInsightActivity.
 * @property defines Allows user to specify defines for Hive job request.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property getDebugInfo Debug info option.
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property queryTimeout Query timeout value (in minutes).  Effective when the HDInsight cluster is with ESP (Enterprise Security Package)
 * @property scriptLinkedService Script linked service reference.
 * @property scriptPath Script path. Type: string (or Expression with resultType string).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property storageLinkedServices Storage linked service references.
 * @property type Type of activity.
 * Expected value is 'HDInsightHive'.
 * @property userProperties Activity user properties.
 * @property variables User specified arguments under hivevar namespace.
 */
public data class HDInsightHiveActivityResponse(
    public val arguments: List<Any>? = null,
    public val defines: Map<String, Any>? = null,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val getDebugInfo: String? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val policy: ActivityPolicyResponse? = null,
    public val queryTimeout: Int? = null,
    public val scriptLinkedService: LinkedServiceReferenceResponse? = null,
    public val scriptPath: Any? = null,
    public val state: String? = null,
    public val storageLinkedServices: List<LinkedServiceReferenceResponse>? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
    public val variables: Map<String, Any>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.HDInsightHiveActivityResponse): HDInsightHiveActivityResponse = HDInsightHiveActivityResponse(
            arguments = javaType.arguments().map({ args0 -> args0 }),
            defines = javaType.defines().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            getDebugInfo = javaType.getDebugInfo().map({ args0 -> args0 }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            queryTimeout = javaType.queryTimeout().map({ args0 -> args0 }).orElse(null),
            scriptLinkedService = javaType.scriptLinkedService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scriptPath = javaType.scriptPath().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            storageLinkedServices = javaType.storageLinkedServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
            variables = javaType.variables().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
