@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A file in an HTTP web server.
 * @property additionalHeaders The headers for the HTTP Request. e.g. request-header-name-1:request-header-value-1
 * ...
 * request-header-name-n:request-header-value-n Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property compression The data compression method used on files.
 * @property description Dataset description.
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property format The format of files.
 * @property linkedServiceName Linked service reference.
 * @property parameters Parameters for dataset.
 * @property relativeUrl The relative URL based on the URL in the HttpLinkedService refers to an HTTP file Type: string (or Expression with resultType string).
 * @property requestBody The body for the HTTP request. Type: string (or Expression with resultType string).
 * @property requestMethod The HTTP method for the HTTP request. Type: string (or Expression with resultType string).
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property type Type of dataset.
 * Expected value is 'HttpFile'.
 */
public data class HttpDatasetResponse(
    public val additionalHeaders: Any? = null,
    public val annotations: List<Any>? = null,
    public val compression: DatasetCompressionResponse? = null,
    public val description: String? = null,
    public val folder: DatasetResponseFolder? = null,
    public val format: Any? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val relativeUrl: Any? = null,
    public val requestBody: Any? = null,
    public val requestMethod: Any? = null,
    public val schema: Any? = null,
    public val structure: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.HttpDatasetResponse): HttpDatasetResponse = HttpDatasetResponse(
            additionalHeaders = javaType.additionalHeaders().map({ args0 -> args0 }).orElse(null),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            compression = javaType.compression().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetCompressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            folder = javaType.folder().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetResponseFolder.Companion.toKotlin(args0)
                })
            }).orElse(null),
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            relativeUrl = javaType.relativeUrl().map({ args0 -> args0 }).orElse(null),
            requestBody = javaType.requestBody().map({ args0 -> args0 }).orElse(null),
            requestMethod = javaType.requestMethod().map({ args0 -> args0 }).orElse(null),
            schema = javaType.schema().map({ args0 -> args0 }).orElse(null),
            structure = javaType.structure().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
