@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Linked service for an HTTP source.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authHeaders The additional HTTP headers in the request to RESTful API used for authorization. Type: key value pairs (value should be string type).
 * @property authenticationType The authentication type to be used to connect to the HTTP server.
 * @property certThumbprint Thumbprint of certificate for ClientCertificate authentication. Only valid for on-premises copy. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property embeddedCertData Base64 encoded certificate data for ClientCertificate authentication. For on-premises copy with ClientCertificate authentication, either CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
 * @property enableServerCertificateValidation If true, validate the HTTPS server SSL certificate. Default value is true. Type: boolean (or Expression with resultType boolean).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData authentication.
 * @property type Type of linked service.
 * Expected value is 'HttpServer'.
 * @property url The base URL of the HTTP endpoint, e.g. https://www.microsoft.com. Type: string (or Expression with resultType string).
 * @property userName User name for Basic, Digest, or Windows authentication. Type: string (or Expression with resultType string).
 */
public data class HttpLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val authHeaders: Any? = null,
    public val authenticationType: String? = null,
    public val certThumbprint: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val embeddedCertData: Any? = null,
    public val enableServerCertificateValidation: Any? = null,
    public val encryptedCredential: String? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val type: String,
    public val url: Any,
    public val userName: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.HttpLinkedServiceResponse): HttpLinkedServiceResponse = HttpLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authHeaders = javaType.authHeaders().map({ args0 -> args0 }).orElse(null),
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            certThumbprint = javaType.certThumbprint().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            embeddedCertData = javaType.embeddedCertData().map({ args0 -> args0 }).orElse(null),
            enableServerCertificateValidation = javaType.enableServerCertificateValidation().map({ args0 ->
                args0
            }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            type = javaType.type(),
            url = javaType.url(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
