@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Http read settings.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property additionalHeaders The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property requestBody The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
 * @property requestMethod The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
 * @property requestTimeout Specifies the timeout for a HTTP client to get HTTP response from HTTP server. Type: string (or Expression with resultType string).
 * @property type The read setting type.
 * Expected value is 'HttpReadSettings'.
 */
public data class HttpReadSettingsResponse(
    public val additionalColumns: Any? = null,
    public val additionalHeaders: Any? = null,
    public val disableMetricsCollection: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val requestBody: Any? = null,
    public val requestMethod: Any? = null,
    public val requestTimeout: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.HttpReadSettingsResponse): HttpReadSettingsResponse = HttpReadSettingsResponse(
            additionalColumns = javaType.additionalColumns().map({ args0 -> args0 }).orElse(null),
            additionalHeaders = javaType.additionalHeaders().map({ args0 -> args0 }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            requestBody = javaType.requestBody().map({ args0 -> args0 }).orElse(null),
            requestMethod = javaType.requestMethod().map({ args0 -> args0 }).orElse(null),
            requestTimeout = javaType.requestTimeout().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
