@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * This activity evaluates a boolean expression and executes either the activities under the ifTrueActivities property or the ifFalseActivities property depending on the result of the expression.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property expression An expression that would evaluate to Boolean. This is used to determine the block of activities (ifTrueActivities or ifFalseActivities) that will be executed.
 * @property ifFalseActivities List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the activity will exit without any action.
 * @property ifTrueActivities List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the activity will exit without any action.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'IfCondition'.
 * @property userProperties Activity user properties.
 */
public data class IfConditionActivityResponse(
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val expression: ExpressionResponse,
    public val ifFalseActivities: List<Any>? = null,
    public val ifTrueActivities: List<Any>? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val state: String? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.IfConditionActivityResponse): IfConditionActivityResponse = IfConditionActivityResponse(
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            expression = javaType.expression().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.ExpressionResponse.Companion.toKotlin(args0)
            }),
            ifFalseActivities = javaType.ifFalseActivities().map({ args0 -> args0 }),
            ifTrueActivities = javaType.ifTrueActivities().map({ args0 -> args0 }),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
