@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Custom setup script properties for a managed dedicated integration runtime.
 * @property blobContainerUri The URI of the Azure blob container that contains the custom setup script.
 * @property sasToken The SAS token of the Azure blob container.
 */
public data class IntegrationRuntimeCustomSetupScriptPropertiesResponse(
    public val blobContainerUri: String? = null,
    public val sasToken: SecureStringResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.IntegrationRuntimeCustomSetupScriptPropertiesResponse): IntegrationRuntimeCustomSetupScriptPropertiesResponse =
            IntegrationRuntimeCustomSetupScriptPropertiesResponse(
                blobContainerUri = javaType.blobContainerUri().map({ args0 -> args0 }).orElse(null),
                sasToken = javaType.sasToken().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
