@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Catalog information for managed dedicated integration runtime.
 * @property catalogAdminPassword The password of the administrator user account of the catalog database.
 * @property catalogAdminUserName The administrator user name of catalog database.
 * @property catalogPricingTier The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
 * @property catalogServerEndpoint The catalog database server URL.
 * @property dualStandbyPairName The dual standby pair name of Azure-SSIS Integration Runtimes to support SSISDB failover.
 */
public data class IntegrationRuntimeSsisCatalogInfoResponse(
    public val catalogAdminPassword: SecureStringResponse? = null,
    public val catalogAdminUserName: String? = null,
    public val catalogPricingTier: String? = null,
    public val catalogServerEndpoint: String? = null,
    public val dualStandbyPairName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.IntegrationRuntimeSsisCatalogInfoResponse): IntegrationRuntimeSsisCatalogInfoResponse = IntegrationRuntimeSsisCatalogInfoResponse(
            catalogAdminPassword = javaType.catalogAdminPassword().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            catalogAdminUserName = javaType.catalogAdminUserName().map({ args0 -> args0 }).orElse(null),
            catalogPricingTier = javaType.catalogPricingTier().map({ args0 -> args0 }).orElse(null),
            catalogServerEndpoint = javaType.catalogServerEndpoint().map({ args0 -> args0 }).orElse(null),
            dualStandbyPairName = javaType.dualStandbyPairName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
