@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VNet properties for managed integration runtime.
 * @property publicIPs Resource IDs of the public IP addresses that this integration runtime will use.
 * @property subnet The name of the subnet this integration runtime will join.
 * @property subnetId The ID of subnet, to which this Azure-SSIS integration runtime will be joined.
 * @property vNetId The ID of the VNet that this integration runtime will join.
 */
public data class IntegrationRuntimeVNetPropertiesResponse(
    public val publicIPs: List<String>? = null,
    public val subnet: String? = null,
    public val subnetId: String? = null,
    public val vNetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.IntegrationRuntimeVNetPropertiesResponse): IntegrationRuntimeVNetPropertiesResponse = IntegrationRuntimeVNetPropertiesResponse(
            publicIPs = javaType.publicIPs().map({ args0 -> args0 }),
            subnet = javaType.subnet().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            vNetId = javaType.vNetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
