@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The data stored in JSON format.
 * @property deserializer Deserializer. Type: string (or Expression with resultType string).
 * @property encodingName The code page name of the preferred encoding. If not provided, the default value is 'utf-8', unless the byte order mark (BOM) denotes another Unicode encoding. The full list of supported values can be found in the 'Name' column of the table of encodings in the following reference: https://go.microsoft.com/fwlink/?linkid=861078. Type: string (or Expression with resultType string).
 * @property filePattern File pattern of JSON. To be more specific, the way of separating a collection of JSON objects. The default value is 'setOfObjects'. It is case-sensitive.
 * @property jsonNodeReference The JSONPath of the JSON array element to be flattened. Example: "$.ArrayPath". Type: string (or Expression with resultType string).
 * @property jsonPathDefinition The JSONPath definition for each column mapping with a customized column name to extract data from JSON file. For fields under root object, start with "$"; for fields inside the array chosen by jsonNodeReference property, start from the array element. Example: {"Column1": "$.Column1Path", "Column2": "Column2PathInArray"}. Type: object (or Expression with resultType object).
 * @property nestingSeparator The character used to separate nesting levels. Default value is '.' (dot). Type: string (or Expression with resultType string).
 * @property serializer Serializer. Type: string (or Expression with resultType string).
 * @property type Type of dataset storage format.
 * Expected value is 'JsonFormat'.
 */
public data class JsonFormatResponse(
    public val deserializer: Any? = null,
    public val encodingName: Any? = null,
    public val filePattern: Any? = null,
    public val jsonNodeReference: Any? = null,
    public val jsonPathDefinition: Any? = null,
    public val nestingSeparator: Any? = null,
    public val serializer: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.JsonFormatResponse): JsonFormatResponse = JsonFormatResponse(
            deserializer = javaType.deserializer().map({ args0 -> args0 }).orElse(null),
            encodingName = javaType.encodingName().map({ args0 -> args0 }).orElse(null),
            filePattern = javaType.filePattern().map({ args0 -> args0 }).orElse(null),
            jsonNodeReference = javaType.jsonNodeReference().map({ args0 -> args0 }).orElse(null),
            jsonPathDefinition = javaType.jsonPathDefinition().map({ args0 -> args0 }).orElse(null),
            nestingSeparator = javaType.nestingSeparator().map({ args0 -> args0 }).orElse(null),
            serializer = javaType.serializer().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
