@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Json write settings.
 * @property filePattern File pattern of JSON. This setting controls the way a collection of JSON objects will be treated. The default value is 'setOfObjects'. It is case-sensitive.
 * @property type The write setting type.
 * Expected value is 'JsonWriteSettings'.
 */
public data class JsonWriteSettingsResponse(
    public val filePattern: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.JsonWriteSettingsResponse): JsonWriteSettingsResponse = JsonWriteSettingsResponse(
            filePattern = javaType.filePattern().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
