@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity for Microsoft Fabric LakeHouse Table sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property partitionNameList Specify the partition column names from sink columns. Type: array of objects (or Expression with resultType array of objects).
 * @property partitionOption Create partitions in folder structure based on one or multiple columns. Each distinct column value (pair) will be a new partition. Possible values include: "None", "PartitionByKey".
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property tableActionOption The type of table action for LakeHouse Table sink. Possible values include: "None", "Append", "Overwrite".
 * @property type Copy sink type.
 * Expected value is 'LakeHouseTableSink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 */
public data class LakeHouseTableSinkResponse(
    public val disableMetricsCollection: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val partitionNameList: Any? = null,
    public val partitionOption: Any? = null,
    public val sinkRetryCount: Any? = null,
    public val sinkRetryWait: Any? = null,
    public val tableActionOption: Any? = null,
    public val type: String,
    public val writeBatchSize: Any? = null,
    public val writeBatchTimeout: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.LakeHouseTableSinkResponse): LakeHouseTableSinkResponse = LakeHouseTableSinkResponse(
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            partitionNameList = javaType.partitionNameList().map({ args0 -> args0 }).orElse(null),
            partitionOption = javaType.partitionOption().map({ args0 -> args0 }).orElse(null),
            sinkRetryCount = javaType.sinkRetryCount().map({ args0 -> args0 }).orElse(null),
            sinkRetryWait = javaType.sinkRetryWait().map({ args0 -> args0 }).orElse(null),
            tableActionOption = javaType.tableActionOption().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            writeBatchSize = javaType.writeBatchSize().map({ args0 -> args0 }).orElse(null),
            writeBatchTimeout = javaType.writeBatchTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
