@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Linked service reference type.
 * @property parameters Arguments for LinkedService.
 * @property referenceName Reference LinkedService name.
 * @property type Linked service reference type.
 */
public data class LinkedServiceReferenceResponse(
    public val parameters: Map<String, Any>? = null,
    public val referenceName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.LinkedServiceReferenceResponse): LinkedServiceReferenceResponse = LinkedServiceReferenceResponse(
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            referenceName = javaType.referenceName(),
            type = javaType.type(),
        )
    }
}
