@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Log settings.
 * @property copyActivityLogSettings Specifies settings for copy activity log.
 * @property enableCopyActivityLog Specifies whether to enable copy activity log. Type: boolean (or Expression with resultType boolean).
 * @property logLocationSettings Log location settings customer needs to provide when enabling log.
 */
public data class LogSettingsResponse(
    public val copyActivityLogSettings: CopyActivityLogSettingsResponse? = null,
    public val enableCopyActivityLog: Any? = null,
    public val logLocationSettings: LogLocationSettingsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.LogSettingsResponse): LogSettingsResponse = LogSettingsResponse(
            copyActivityLogSettings = javaType.copyActivityLogSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.CopyActivityLogSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enableCopyActivityLog = javaType.enableCopyActivityLog().map({ args0 -> args0 }).orElse(null),
            logLocationSettings = javaType.logLocationSettings().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LogLocationSettingsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
