@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
 * @property computeProperties The compute resource for managed integration runtime.
 * @property customerVirtualNetwork The name of virtual network to which Azure-SSIS integration runtime will join
 * @property description Integration runtime description.
 * @property managedVirtualNetwork Managed Virtual Network reference.
 * @property ssisProperties SSIS properties for managed integration runtime.
 * @property state Integration runtime state, only valid for managed dedicated integration runtime.
 * @property type The type of integration runtime.
 * Expected value is 'Managed'.
 */
public data class ManagedIntegrationRuntimeResponse(
    public val computeProperties: IntegrationRuntimeComputePropertiesResponse? = null,
    public val customerVirtualNetwork: IntegrationRuntimeCustomerVirtualNetworkResponse? = null,
    public val description: String? = null,
    public val managedVirtualNetwork: ManagedVirtualNetworkReferenceResponse? = null,
    public val ssisProperties: IntegrationRuntimeSsisPropertiesResponse? = null,
    public val state: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ManagedIntegrationRuntimeResponse): ManagedIntegrationRuntimeResponse = ManagedIntegrationRuntimeResponse(
            computeProperties = javaType.computeProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeComputePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customerVirtualNetwork = javaType.customerVirtualNetwork().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeCustomerVirtualNetworkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            managedVirtualNetwork = javaType.managedVirtualNetwork().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ManagedVirtualNetworkReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ssisProperties = javaType.ssisProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeSsisPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state(),
            type = javaType.type(),
        )
    }
}
