@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Managed integration runtime status.
 * @property createTime The time at which the integration runtime was created, in ISO8601 format.
 * @property dataFactoryName The data factory name which the integration runtime belong to.
 * @property lastOperation The last operation result that occurred on this integration runtime.
 * @property nodes The list of nodes for managed integration runtime.
 * @property otherErrors The errors that occurred on this integration runtime.
 * @property state The state of integration runtime.
 * @property type The type of integration runtime.
 * Expected value is 'Managed'.
 */
public data class ManagedIntegrationRuntimeStatusResponse(
    public val createTime: String,
    public val dataFactoryName: String,
    public val lastOperation: ManagedIntegrationRuntimeOperationResultResponse,
    public val nodes: List<ManagedIntegrationRuntimeNodeResponse>,
    public val otherErrors: List<ManagedIntegrationRuntimeErrorResponse>,
    public val state: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ManagedIntegrationRuntimeStatusResponse): ManagedIntegrationRuntimeStatusResponse = ManagedIntegrationRuntimeStatusResponse(
            createTime = javaType.createTime(),
            dataFactoryName = javaType.dataFactoryName(),
            lastOperation = javaType.lastOperation().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.ManagedIntegrationRuntimeOperationResultResponse.Companion.toKotlin(args0)
            }),
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ManagedIntegrationRuntimeNodeResponse.Companion.toKotlin(args0)
                })
            }),
            otherErrors = javaType.otherErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ManagedIntegrationRuntimeErrorResponse.Companion.toKotlin(args0)
                })
            }),
            state = javaType.state(),
            type = javaType.type(),
        )
    }
}
