@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a managed private endpoint
 * @property connectionState The managed private endpoint connection state
 * @property fqdns Fully qualified domain names
 * @property groupId The groupId to which the managed private endpoint is created
 * @property isReserved Denotes whether the managed private endpoint is reserved
 * @property privateLinkResourceId The ARM resource ID of the resource to which the managed private endpoint is created
 * @property provisioningState The managed private endpoint provisioning state
 */
public data class ManagedPrivateEndpointResponse(
    public val connectionState: ConnectionStatePropertiesResponse? = null,
    public val fqdns: List<String>? = null,
    public val groupId: String? = null,
    public val isReserved: Boolean,
    public val privateLinkResourceId: String? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ManagedPrivateEndpointResponse): ManagedPrivateEndpointResponse = ManagedPrivateEndpointResponse(
            connectionState = javaType.connectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ConnectionStatePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fqdns = javaType.fqdns().map({ args0 -> args0 }),
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            isReserved = javaType.isReserved(),
            privateLinkResourceId = javaType.privateLinkResourceId().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
